package gov.va.med.mhv.integration.phr.message;

import java.lang.annotation.Annotation;

/**
 * User: Rob Murtha
*/
public class Selector implements MessageSelector {
    String messageName;
    String extractType;
    String messageFormat;
    String routingStatus;

    public Selector(String messageName, String extractType, String messageFormat, String routingStatus) {
        this.messageName=messageName;
        this.extractType=extractType;
        this.messageFormat=messageFormat;
        this.routingStatus=routingStatus;
    }

    public String messageName() {
        return this.messageName;
    }

    public String extractType() {
        return this.extractType;
    }

    public String messageFormat() {
        return this.messageFormat;
    }

    public String routingStatus() {
        return this.routingStatus;
    }

    public Class<? extends Annotation> annotationType() {
        return MessageSelector.class;
    }

    public String toString() {
        return "Selector{" +
                "messageName='" + messageName() + '\'' +
                ", extractType='" + extractType() + '\'' +
                ", messageFormat='" + messageFormat() + '\'' +
                ", routingStatus='" + routingStatus() + '\'' +
                '}';
    }

    public static String toString(MessageSelector selector) {
        String result=null;
        if(selector!=null) {
            result="Selector{" +
                "messageName='" + selector.messageName() + '\'' +
                ", extractType='" + selector.extractType() + '\'' +
                ", messageFormat='" + selector.messageFormat() + '\'' +
                ", routingStatus='" + selector.routingStatus() + '\'' +
                '}';
        } else {
            result="Selector{null}";
        }
        return result;
    }
}
